#pragma once
#include "../sdkIncludes.h"

typedef void* JMHandle;
typedef long JMResult;

/**
*@brief defined of the result for HMResult
*/
#define JMSucceed ((JMResult)1)
#define JMFailed ((JMResult)0)

  namespace JM_SDK {

	extern "C"
	{
		JMResult jmevent_callback_set(const char *pEventName, void *pfFuncCallBack);
		JMResult jmsdk_function_get(const char *pFunctionName, void **pfRemotFunc);
	};

}


/***
*	IDSMgrImpl
***/
#define JMSDK_IDSMgr_setDSEvent "JMSDK_IDSMgr_setDSEvent"

#define JMSDK_IDSMgr_isInDS "JMSDK_IDSMgr_isInDS"

#define JMSDK_IDSMgr_isSharingInDS "JMSDK_IDSMgr_isSharingInDS"

#define JMSDK_IDSMgr_canStartDS "JMSDK_IDSMgr_canStartDS"

#define JMSDK_IDSMgr_canJoinDS "JMSDK_IDSMgr_canJoinDS"

#define JMSDK_IDSMgr_startDS "JMSDK_IDSMgr_startDS"

#define JMSDK_IDSMgr_joinDS "JMSDK_IDSMgr_joinDS"

#define JMSDK_IDSMgr_declineDSInvitation "JMSDK_IDSMgr_declineDSInvitation"

#define JMSDK_IDSMgr_inviteUser2DS "JMSDK_IDSMgr_inviteUser2DS"

#define JMSDK_IDSMgr_endDS "JMSDK_IDSMgr_endDS"

#define JMSDK_IDSMgr_reSharing "JMSDK_IDSMgr_reSharing"

#define JMSDK_IDSMgr_changePresenter "JMSDK_IDSMgr_changePresenter"

#define JMSDK_IDSMgr_receiveDSInvitation "JMSDK_IDSMgr_receiveDSInvitation"

#define JMSDK_IDSMgr_receiveDSDecline "JMSDK_IDSMgr_receiveDSDecline"

#define JMSDK_IDSMgr_receiveDSCancelled "JMSDK_IDSMgr_receiveDSCancelled"

typedef JMResult (*pf_jmsdk_IDSMgr_setDSEvent)(IDSEvent* pEvent);

typedef JMResult (*pf_jmsdk_IDSMgr_isInDS)(bool &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_isSharingInDS)(bool &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_canStartDS)(const PString sessionName, bool &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_canJoinDS)(const PString sessionName, bool &ret);

typedef JMResult (*pf_jmsdk_IDSMgr_startDS)(const PString sessionName, const PString serverUrl, const PString token);

typedef JMResult (*pf_jmsdk_IDSMgr_joinDS)(const PString sessionName);

typedef JMResult (*pf_jmsdk_IDSMgr_declineDSInvitation)(const PString sessionName);

typedef JMResult (*pf_jmsdk_IDSMgr_inviteUser2DS)(const PString sessionName);

typedef JMResult (*pf_jmsdk_IDSMgr_endDS)();

typedef JMResult (*pf_jmsdk_IDSMgr_reSharing)();

typedef JMResult (*pf_jmsdk_IDSMgr_changePresenter)();

typedef JMResult (*pf_jmsdk_IDSMgr_receiveDSInvitation)(const PString sessionName, const PString cmdMsg);

typedef JMResult (*pf_jmsdk_IDSMgr_receiveDSDecline)(const PString sessionName);

typedef JMResult (*pf_jmsdk_IDSMgr_receiveDSCancelled)(const PString sessionName);


/***
*	IInstantMeetingMgrImpl
***/
#define JMSDK_IInstantMeetingMgr_registerIMEvent "JMSDK_IInstantMeetingMgr_registerIMEvent"

#define JMSDK_IInstantMeetingMgr_unregisterIMEvent "JMSDK_IInstantMeetingMgr_unregisterIMEvent"

#define JMSDK_IInstantMeetingMgr_isInMeeting "JMSDK_IInstantMeetingMgr_isInMeeting"

#define JMSDK_IInstantMeetingMgr_isInSharing "JMSDK_IInstantMeetingMgr_isInSharing"

#define JMSDK_IInstantMeetingMgr_canStartMeeting "JMSDK_IInstantMeetingMgr_canStartMeeting"

#define JMSDK_IInstantMeetingMgr_canJoinMeeting "JMSDK_IInstantMeetingMgr_canJoinMeeting"

#define JMSDK_IInstantMeetingMgr_start "JMSDK_IInstantMeetingMgr_start"

#define JMSDK_IInstantMeetingMgr_invite "JMSDK_IInstantMeetingMgr_invite"

#define JMSDK_IInstantMeetingMgr_join "JMSDK_IInstantMeetingMgr_join"

#define JMSDK_IInstantMeetingMgr_decline "JMSDK_IInstantMeetingMgr_decline"

#define JMSDK_IInstantMeetingMgr_receiveMeetingInvitation "JMSDK_IInstantMeetingMgr_receiveMeetingInvitation"

#define JMSDK_IInstantMeetingMgr_receiveMeetingDeclinedMsg "JMSDK_IInstantMeetingMgr_receiveMeetingDeclinedMsg"

#define JMSDK_IInstantMeetingMgr_receiveMeetingCancelledMsg "JMSDK_IInstantMeetingMgr_receiveMeetingCancelledMsg"

#define JMSDK_IInstantMeetingMgr_isWbxInstantMeeting "JMSDK_IInstantMeetingMgr_isWbxInstantMeeting"

#define JMSDK_IInstantMeetingMgr_startCmr "JMSDK_IInstantMeetingMgr_startCmr"

#define JMSDK_IInstantMeetingMgr_joinCmr "JMSDK_IInstantMeetingMgr_joinCmr"

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_registerIMEvent)(IInstantMeetingEvent* pEvent);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_unregisterIMEvent)(IInstantMeetingEvent* pEvent);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_isInMeeting)(bool &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_isInSharing)(bool &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_canStartMeeting)(bool &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_canJoinMeeting)(bool &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_start)(const PString meetingName, const PString inviteeList);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_invite)(const PString inviteeList);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_join)(const PString sessionName);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_decline)(const PString sessionName);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_receiveMeetingInvitation)(const PString sessionName, const PString cmdMsg);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_receiveMeetingDeclinedMsg)(const PString sessionName, const PString cmdMsg);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_receiveMeetingCancelledMsg)(const PString sessionName, const PString cmdMsg);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_isWbxInstantMeeting)(const PString meetingKey, bool &ret);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_startCmr)(bool launch);

typedef JMResult (*pf_jmsdk_IInstantMeetingMgr_joinCmr)(const PString strSiteURL, const PString strMeetingKey, const PString strMTGTK);


/***
*	IMeetingCalendarImpl
***/
#define JMSDK_IMeetingCalendar_setMCEvent "JMSDK_IMeetingCalendar_setMCEvent"

#define JMSDK_IMeetingCalendar_setReminderTime "JMSDK_IMeetingCalendar_setReminderTime"

#define JMSDK_IMeetingCalendar_setMeetingReminderEnable "JMSDK_IMeetingCalendar_setMeetingReminderEnable"

#define JMSDK_IMeetingCalendar_initialize "JMSDK_IMeetingCalendar_initialize"

#define JMSDK_IMeetingCalendar_getIntegrationCalendarType "JMSDK_IMeetingCalendar_getIntegrationCalendarType"

#define JMSDK_IMeetingCalendar_isMeetingEnabled "JMSDK_IMeetingCalendar_isMeetingEnabled"

#define JMSDK_IMeetingCalendar_isCalendarEnabled "JMSDK_IMeetingCalendar_isCalendarEnabled"

#define JMSDK_IMeetingCalendar_isMeetingInProgress "JMSDK_IMeetingCalendar_isMeetingInProgress"

#define JMSDK_IMeetingCalendar_listMeeting "JMSDK_IMeetingCalendar_listMeeting"

#define JMSDK_IMeetingCalendar_refreshMeeting "JMSDK_IMeetingCalendar_refreshMeeting"

#define JMSDK_IMeetingCalendar_getMeetingDay "JMSDK_IMeetingCalendar_getMeetingDay"

#define JMSDK_IMeetingCalendar_getMeetingList "JMSDK_IMeetingCalendar_getMeetingList"

#define JMSDK_IMeetingCalendar_getMeetingDetail "JMSDK_IMeetingCalendar_getMeetingDetail"

#define JMSDK_IMeetingCalendar_viewMeetingById "JMSDK_IMeetingCalendar_viewMeetingById"

#define JMSDK_IMeetingCalendar_launchMeetingById "JMSDK_IMeetingCalendar_launchMeetingById"

#define JMSDK_IMeetingCalendar_invokeSystemTimeChange "JMSDK_IMeetingCalendar_invokeSystemTimeChange"

#define JMSDK_IMeetingCalendar_sendEmail "JMSDK_IMeetingCalendar_sendEmail"

#define JMSDK_IMeetingCalendar_receiveReminder "JMSDK_IMeetingCalendar_receiveReminder"

#define JMSDK_IMeetingCalendar_getRemindCommandMessage "JMSDK_IMeetingCalendar_getRemindCommandMessage"

#define JMSDK_IMeetingCalendar_getInviteCommandMessage "JMSDK_IMeetingCalendar_getInviteCommandMessage"

#define JMSDK_IMeetingCalendar_getCMRInfo "JMSDK_IMeetingCalendar_getCMRInfo"

typedef JMResult (*pf_jmsdk_IMeetingCalendar_setMCEvent)(IMeetingCalendarEvent* pEvent);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_setReminderTime)(long start, long stop);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_setMeetingReminderEnable)(bool isEnable);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_initialize)(CalendarType type);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getIntegrationCalendarType)(CalendarType &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_isMeetingEnabled)(bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_isCalendarEnabled)(bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_isMeetingInProgress)(const PString meetingID, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_listMeeting)(MeetingTime mtDay);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_refreshMeeting)();

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getMeetingDay)(MeetingTime& mtDay, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getMeetingList)(MeetingList& meetingList, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getMeetingDetail)(const PString meetingID, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_viewMeetingById)(const PString meetingID, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_launchMeetingById)(const PString meetingID, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_invokeSystemTimeChange)();

typedef JMResult (*pf_jmsdk_IMeetingCalendar_sendEmail)(const PString tos, const PString subject, const PString body, const PString meetingID, bool &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_receiveReminder)(const PString sender, ReminderType remindType, const PString remindMsg);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getRemindCommandMessage)(const PString meetingID, PString &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getInviteCommandMessage)(const PString meetingID, PString &ret);

typedef JMResult (*pf_jmsdk_IMeetingCalendar_getCMRInfo)(const PString cmrInfo);


/***
*	IWbxMeetingAccountQueryImpl
***/
#define JMSDK_IWbxMeetingAccountQuery_registerQueryEvent "JMSDK_IWbxMeetingAccountQuery_registerQueryEvent"

#define JMSDK_IWbxMeetingAccountQuery_unregisterQueryEvent "JMSDK_IWbxMeetingAccountQuery_unregisterQueryEvent"

#define JMSDK_IWbxMeetingAccountQuery_isExistAccount "JMSDK_IWbxMeetingAccountQuery_isExistAccount"

#define JMSDK_IWbxMeetingAccountQuery_getAccountProperty "JMSDK_IWbxMeetingAccountQuery_getAccountProperty"

#define JMSDK_IWbxMeetingAccountQuery_getSiteProperty "JMSDK_IWbxMeetingAccountQuery_getSiteProperty"

#define JMSDK_IWbxMeetingAccountQuery_getAccountName "JMSDK_IWbxMeetingAccountQuery_getAccountName"

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountQuery_registerQueryEvent)(IWbxMeetingAccountEvent* pEvent);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountQuery_unregisterQueryEvent)(IWbxMeetingAccountEvent* pEvent);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountQuery_isExistAccount)(bool &ret);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountQuery_getAccountProperty)(WbxMeetingAccountProperty &ret);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountQuery_getSiteProperty)(WbxMeetingSiteProperty &ret);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountQuery_getAccountName)(PString &ret);


/***
*	IWbxMeetingAccountOperatorImpl
***/
#define JMSDK_IWbxMeetingAccountOperator_clearAccount "JMSDK_IWbxMeetingAccountOperator_clearAccount"

#define JMSDK_IWbxMeetingAccountOperator_resetAccount "JMSDK_IWbxMeetingAccountOperator_resetAccount"

#define JMSDK_IWbxMeetingAccountOperator_refreshSessionTicket "JMSDK_IWbxMeetingAccountOperator_refreshSessionTicket"

#define JMSDK_IWbxMeetingAccountOperator_openOneClickSetting "JMSDK_IWbxMeetingAccountOperator_openOneClickSetting"

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountOperator_clearAccount)();

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountOperator_resetAccount)(const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountOperator_refreshSessionTicket)(const PString sessionTicket);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountOperator_openOneClickSetting)();


/***
*	IWbxMeetingAccountValidationImpl
***/
#define JMSDK_IWbxMeetingAccountValidation_setValidationEvent "JMSDK_IWbxMeetingAccountValidation_setValidationEvent"

#define JMSDK_IWbxMeetingAccountValidation_getSiteSSOInfo "JMSDK_IWbxMeetingAccountValidation_getSiteSSOInfo"

#define JMSDK_IWbxMeetingAccountValidation_checkSiteListSSOInfo "JMSDK_IWbxMeetingAccountValidation_checkSiteListSSOInfo"

#define JMSDK_IWbxMeetingAccountValidation_checkSiteSSOInfo "JMSDK_IWbxMeetingAccountValidation_checkSiteSSOInfo"

#define JMSDK_IWbxMeetingAccountValidation_verifyAccount "JMSDK_IWbxMeetingAccountValidation_verifyAccount"

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountValidation_setValidationEvent)(IWbxMeetingAccountValidationEvent* pEvent);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountValidation_getSiteSSOInfo)(const PString url, CHECK_SITE_SSO_RESULT &ret);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountValidation_checkSiteListSSOInfo)(const PString siteList);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountValidation_checkSiteSSOInfo)(const PString url);

typedef JMResult (*pf_jmsdk_IWbxMeetingAccountValidation_verifyAccount)(const PString siteURL, const PString userName, const PString userCred, bool isSSO);


/***
*	IJMSDKInstanceImpl
***/
#define JMSDK_IJMSDKInstance_createJMSDK "JMSDK_IJMSDKInstance_createJMSDK"

#define JMSDK_IJMSDKInstance_deleteJMSDK "JMSDK_IJMSDKInstance_deleteJMSDK"

#define JMSDK_IJMSDKInstance_startJMSDK "JMSDK_IJMSDKInstance_startJMSDK"

#define JMSDK_IJMSDKInstance_stopJMSDK "JMSDK_IJMSDKInstance_stopJMSDK"

#define JMSDK_IJMSDKInstance_ChangeCapability "JMSDK_IJMSDKInstance_ChangeCapability"

typedef JMResult (*pf_jmsdk_IJMSDKInstance_createJMSDK)(bool isDesktopShareEnable, bool isMeetingAccountEnable, bool isInstantMeetingEnable, bool isMeetingListEnable);

typedef JMResult (*pf_jmsdk_IJMSDKInstance_deleteJMSDK)();

typedef JMResult (*pf_jmsdk_IJMSDKInstance_startJMSDK)();

typedef JMResult (*pf_jmsdk_IJMSDKInstance_stopJMSDK)();

typedef JMResult (*pf_jmsdk_IJMSDKInstance_ChangeCapability)(bool isDesktopShareEnable, bool isMeetingAccountEnable, bool isInstantMeetingEnable, bool isMeetingListEnable);


/***
*	IJabberMeetingSDKDelegateWrapper
***/
#define JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingInvitation "JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingInvitation"

#define JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingCancelInvitation "JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingCancelInvitation"

#define JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingDecline "JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingDecline"

#define JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingInvitation "JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingInvitation"

#define JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingCancelInvitation "JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingCancelInvitation"

#define JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingDecline "JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingDecline"

#define JMSDK_IJabberMeetingSDKDelegate_getAttendeeEmail "JMSDK_IJabberMeetingSDKDelegate_getAttendeeEmail"

#define JMSDK_IJabberMeetingSDKDelegate_getAttendeeDispalyName "JMSDK_IJabberMeetingSDKDelegate_getAttendeeDispalyName"

#define JMSDK_IJabberMeetingSDKDelegate_hideChatWindow "JMSDK_IJabberMeetingSDKDelegate_hideChatWindow"

#define JMSDK_IJabberMeetingSDKDelegate_showChatWindow "JMSDK_IJabberMeetingSDKDelegate_showChatWindow"

#define JMSDK_IJabberMeetingSDKDelegate_onUserTryLeave "JMSDK_IJabberMeetingSDKDelegate_onUserTryLeave"

#define JMSDK_IJabberMeetingSDKDelegate_getJabberAccountName "JMSDK_IJabberMeetingSDKDelegate_getJabberAccountName"

#define JMSDK_IJabberMeetingSDKDelegate_getJabberAccountNameFromEmail "JMSDK_IJabberMeetingSDKDelegate_getJabberAccountNameFromEmail"

#define JMSDK_IJabberMeetingSDKDelegate_addInMeetingPresence "JMSDK_IJabberMeetingSDKDelegate_addInMeetingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_removeInMeetingPresence "JMSDK_IJabberMeetingSDKDelegate_removeInMeetingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_addInWebExMeetingPresence "JMSDK_IJabberMeetingSDKDelegate_addInWebExMeetingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_removeInWebExMeetingPresence "JMSDK_IJabberMeetingSDKDelegate_removeInWebExMeetingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_addInWebExSharingPresence "JMSDK_IJabberMeetingSDKDelegate_addInWebExSharingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_removeInWebExSharingPresence "JMSDK_IJabberMeetingSDKDelegate_removeInWebExSharingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_addInDesktopSharingPresence "JMSDK_IJabberMeetingSDKDelegate_addInDesktopSharingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_removeInDesktopSharingPresence "JMSDK_IJabberMeetingSDKDelegate_removeInDesktopSharingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_addSharingInDesktopSharingPresence "JMSDK_IJabberMeetingSDKDelegate_addSharingInDesktopSharingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_removeShareingInDesktopSharingPresence "JMSDK_IJabberMeetingSDKDelegate_removeShareingInDesktopSharingPresence"

#define JMSDK_IJabberMeetingSDKDelegate_isAccount "JMSDK_IJabberMeetingSDKDelegate_isAccount"

#define JMSDK_IJabberMeetingSDKDelegate_IsDSPolicyEnable "JMSDK_IJabberMeetingSDKDelegate_IsDSPolicyEnable"

#define JMSDK_IJabberMeetingSDKDelegate_hasDSCapability "JMSDK_IJabberMeetingSDKDelegate_hasDSCapability"

#define JMSDK_IJabberMeetingSDKDelegate_hasIMCapability "JMSDK_IJabberMeetingSDKDelegate_hasIMCapability"

#define JMSDK_IJabberMeetingSDKDelegate_isBuddyOnline "JMSDK_IJabberMeetingSDKDelegate_isBuddyOnline"

#define JMSDK_IJabberMeetingSDKDelegate_isCupModel "JMSDK_IJabberMeetingSDKDelegate_isCupModel"

#define JMSDK_IJabberMeetingSDKDelegate_isWbxMeetingEnabled "JMSDK_IJabberMeetingSDKDelegate_isWbxMeetingEnabled"

#define JMSDK_IJabberMeetingSDKDelegate_sendMeetingReminder "JMSDK_IJabberMeetingSDKDelegate_sendMeetingReminder"

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendInstantMeetingInvitation)(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendInstantMeetingCancelInvitation)(const PString buddyName);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendInstantMeetingDecline)(const PString buddyName);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendDesktopSharingInvitation)(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendDesktopSharingCancelInvitation)(const PString buddyName);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendDesktopSharingDecline)(const PString buddyName);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_getAttendeeEmail)(const PString attendeeJID, PString& attendeeEmail);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_getAttendeeDispalyName)(const PString attendeeJID, PString& attendeeDN);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_hideChatWindow)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_showChatWindow)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_onUserTryLeave)(bool isHost);

typedef PString (*pf_jmsdk_IJabberMeetingSDKDelegate_getJabberAccountName)();

typedef PString (*pf_jmsdk_IJabberMeetingSDKDelegate_getJabberAccountNameFromEmail)(const PString email);

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_addInMeetingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_removeInMeetingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_addInWebExMeetingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_removeInWebExMeetingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_addInWebExSharingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_removeInWebExSharingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_addInDesktopSharingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_removeInDesktopSharingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_addSharingInDesktopSharingPresence)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_removeShareingInDesktopSharingPresence)();

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_isAccount)(const PString & sessionName);

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_IsDSPolicyEnable)(const PString & sessionName, int & nPolicyResult);

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_hasDSCapability)(const PString & sessionName);

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_hasIMCapability)(const PString & sessionName);

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_isBuddyOnline)(const PString & sessionName);

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_isCupModel)();

typedef bool (*pf_jmsdk_IJabberMeetingSDKDelegate_isWbxMeetingEnabled)();

typedef void (*pf_jmsdk_IJabberMeetingSDKDelegate_sendMeetingReminder)(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);


/***
*	IJMLoggerWrapper
***/
#define JMSDK_IJMLogger_log "JMSDK_IJMLogger_log"

typedef void (*pf_jmsdk_IJMLogger_log)(int level, const char *sourceFile, int sourceLine, const char *function, const char *fmt, va_list args);


/***
*	IMeetingCalendarEventWrapper
***/
#define JMSDK_IMeetingCalendarEvent_onCalendarEnabled "JMSDK_IMeetingCalendarEvent_onCalendarEnabled"

#define JMSDK_IMeetingCalendarEvent_onMeetingEnabled "JMSDK_IMeetingCalendarEvent_onMeetingEnabled"

#define JMSDK_IMeetingCalendarEvent_onMeetingListed "JMSDK_IMeetingCalendarEvent_onMeetingListed"

#define JMSDK_IMeetingCalendarEvent_onGetMeetingDetail "JMSDK_IMeetingCalendarEvent_onGetMeetingDetail"

#define JMSDK_IMeetingCalendarEvent_onMeetingOvernight "JMSDK_IMeetingCalendarEvent_onMeetingOvernight"

#define JMSDK_IMeetingCalendarEvent_onMeetingReminderHappened "JMSDK_IMeetingCalendarEvent_onMeetingReminderHappened"

#define JMSDK_IMeetingCalendarEvent_onMeetingReminderUpdated "JMSDK_IMeetingCalendarEvent_onMeetingReminderUpdated"

#define JMSDK_IMeetingCalendarEvent_onMeetingReminderEnded "JMSDK_IMeetingCalendarEvent_onMeetingReminderEnded"

#define JMSDK_IMeetingCalendarEvent_onMeetingStarted "JMSDK_IMeetingCalendarEvent_onMeetingStarted"

#define JMSDK_IMeetingCalendarEvent_onMeetingEnded "JMSDK_IMeetingCalendarEvent_onMeetingEnded"

#define JMSDK_IMeetingCalendarEvent_onMeetingError "JMSDK_IMeetingCalendarEvent_onMeetingError"

#define JMSDK_IMeetingCalendarEvent_onMeetingInvitationReceived "JMSDK_IMeetingCalendarEvent_onMeetingInvitationReceived"

#define JMSDK_IMeetingCalendarEvent_onMeetingInvitationCanceled "JMSDK_IMeetingCalendarEvent_onMeetingInvitationCanceled"

#define JMSDK_IMeetingCalendarEvent_onMeetingDeclined "JMSDK_IMeetingCalendarEvent_onMeetingDeclined"

#define JMSDK_IMeetingCalendarEvent_onPopupMeetingWaitDialog "JMSDK_IMeetingCalendarEvent_onPopupMeetingWaitDialog"

#define JMSDK_IMeetingCalendarEvent_onCloseMeetingWaitDialog "JMSDK_IMeetingCalendarEvent_onCloseMeetingWaitDialog"

#define JMSDK_IMeetingCalendarEvent_onCmrMeetingStarted "JMSDK_IMeetingCalendarEvent_onCmrMeetingStarted"

#define JMSDK_IMeetingCalendarEvent_onCmrMeetingJoined "JMSDK_IMeetingCalendarEvent_onCmrMeetingJoined"

#define JMSDK_IMeetingCalendarEvent_onCmrMeetingEnded "JMSDK_IMeetingCalendarEvent_onCmrMeetingEnded"

#define JMSDK_IMeetingCalendarEvent_onCmrMeetingError "JMSDK_IMeetingCalendarEvent_onCmrMeetingError"

#define JMSDK_IMeetingCalendarEvent_onCmrInfo "JMSDK_IMeetingCalendarEvent_onCmrInfo"

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCalendarEnabled)(bool bEnable);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingEnabled)(bool bEnable);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingListed)(MeetingCalendarErrorCode errCode);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onGetMeetingDetail)(const MeetingData& meeting);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingOvernight)();

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingReminderHappened)(const ReminderInfo& reminder);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingReminderUpdated)(const ReminderInfo& reminder);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingReminderEnded)(const PString meetingID);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingStarted)(const PString sessionName, const PString meetingID, bool host);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingEnded)(const PString sessionName, const PString meetingID);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingError)(const PString sessionName, const PString meetingID, int errCode);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingInvitationReceived)(const PString sessionName, const PString meetingTopic);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingInvitationCanceled)(const PString sessionName);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onMeetingDeclined)(const PString sessionName, const PString buddyName);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onPopupMeetingWaitDialog)();

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCloseMeetingWaitDialog)();

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCmrMeetingStarted)(const JM_SDK::CmrMeetingData & meetingInfo);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCmrMeetingJoined)();

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCmrMeetingEnded)();

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCmrMeetingError)(JM_SDK::INSTANT_MEETING_ERROR_CODE errorCode);

typedef void (*pf_jmsdk_IMeetingCalendarEvent_onCmrInfo)(const PString cmrInfo);


/***
*	IWbxMeetingAccountValidationEventWrapper
***/
#define JMSDK_IWbxMeetingAccountValidationEvent_onCheckSiteListSSOInfo "JMSDK_IWbxMeetingAccountValidationEvent_onCheckSiteListSSOInfo"

#define JMSDK_IWbxMeetingAccountValidationEvent_onCheckSiteSSOInfo "JMSDK_IWbxMeetingAccountValidationEvent_onCheckSiteSSOInfo"

#define JMSDK_IWbxMeetingAccountValidationEvent_onVerifyAccount "JMSDK_IWbxMeetingAccountValidationEvent_onVerifyAccount"

typedef void (*pf_jmsdk_IWbxMeetingAccountValidationEvent_onCheckSiteListSSOInfo)();

typedef void (*pf_jmsdk_IWbxMeetingAccountValidationEvent_onCheckSiteSSOInfo)(WBX_MEETING_ACCOUNT_ERROR errorCode, const PString url, CHECK_SITE_SSO_RESULT result);

typedef void (*pf_jmsdk_IWbxMeetingAccountValidationEvent_onVerifyAccount)(WBX_MEETING_ACCOUNT_ERROR result, const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty);


/***
*	IDSEventWrapper
***/
#define JMSDK_IDSEvent_onPopupDSWaitingDialog "JMSDK_IDSEvent_onPopupDSWaitingDialog"

#define JMSDK_IDSEvent_onCloseDSWaitingDialog "JMSDK_IDSEvent_onCloseDSWaitingDialog"

#define JMSDK_IDSEvent_onDSStarted "JMSDK_IDSEvent_onDSStarted"

#define JMSDK_IDSEvent_onDSEnded "JMSDK_IDSEvent_onDSEnded"

#define JMSDK_IDSEvent_onDSError "JMSDK_IDSEvent_onDSError"

#define JMSDK_IDSEvent_onPopupChatWindow "JMSDK_IDSEvent_onPopupChatWindow"

#define JMSDK_IDSEvent_onMinimizeChatWindow "JMSDK_IDSEvent_onMinimizeChatWindow"

#define JMSDK_IDSEvent_onDSInvitation "JMSDK_IDSEvent_onDSInvitation"

#define JMSDK_IDSEvent_onDSDeclined "JMSDK_IDSEvent_onDSDeclined"

#define JMSDK_IDSEvent_onDSCancelled "JMSDK_IDSEvent_onDSCancelled"

#define JMSDK_IDSEvent_onSharingStopped "JMSDK_IDSEvent_onSharingStopped"

#define JMSDK_IDSEvent_onBuddyJoined "JMSDK_IDSEvent_onBuddyJoined"

#define JMSDK_IDSEvent_onUserTryLeave "JMSDK_IDSEvent_onUserTryLeave"

#define JMSDK_IDSEvent_onUserLeft "JMSDK_IDSEvent_onUserLeft"

#define JMSDK_IDSEvent_onPresenterChanged "JMSDK_IDSEvent_onPresenterChanged"

typedef void (*pf_jmsdk_IDSEvent_onPopupDSWaitingDialog)();

typedef void (*pf_jmsdk_IDSEvent_onCloseDSWaitingDialog)();

typedef void (*pf_jmsdk_IDSEvent_onDSStarted)(const PString sessionName, bool isHost);

typedef void (*pf_jmsdk_IDSEvent_onDSEnded)(const PString sessionName, bool isHost);

typedef void (*pf_jmsdk_IDSEvent_onDSError)(const DS_ERROR_CODE errorCode, const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onPopupChatWindow)(const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onMinimizeChatWindow)(const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onDSInvitation)(const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onDSDeclined)(const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onDSCancelled)(const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onSharingStopped)(const PString sessionName);

typedef void (*pf_jmsdk_IDSEvent_onBuddyJoined)();

typedef void (*pf_jmsdk_IDSEvent_onUserTryLeave)(bool isHost);

typedef void (*pf_jmsdk_IDSEvent_onUserLeft)();

typedef void (*pf_jmsdk_IDSEvent_onPresenterChanged)();


/***
*	INetworkTransportWrapper
***/
#define JMSDK_INetworkTransport_HttpRequest "JMSDK_INetworkTransport_HttpRequest"

#define JMSDK_INetworkTransport_HttpRequestAsync "JMSDK_INetworkTransport_HttpRequestAsync"

#define JMSDK_INetworkTransport_Registered "JMSDK_INetworkTransport_Registered"

typedef void (*pf_jmsdk_INetworkTransport_HttpRequest)(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

typedef void (*pf_jmsdk_INetworkTransport_HttpRequestAsync)(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

typedef bool (*pf_jmsdk_INetworkTransport_Registered)();

